/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.generator;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mrbysco.slabmachines.blocks.TNTSlabBlock;
import com.mrbysco.slabmachines.init.SlabRegistry;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="slabmachines", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SlabDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new Loots(generator));
            generator.m_123914_((DataProvider)new MineableProvider(generator, helper));
        }
        if (event.includeClient()) {
            generator.m_123914_((DataProvider)new ItemModels(generator, helper));
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(() -> new Blocks(), (Object)LootContextParamSets.f_81421_));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)name, (LootTable)table));
        }

        private class Blocks
        extends BlockLoot {
            private Blocks() {
            }

            protected void addTables() {
                this.m_124288_((Block)SlabRegistry.CRAFTING_TABLE_SLAB.get());
                this.m_124175_((Block)SlabRegistry.FURNACE_SLAB.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
                this.m_124175_((Block)SlabRegistry.CHEST_SLAB.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
                this.m_124175_((Block)SlabRegistry.TRAPPED_CHEST_SLAB.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
                this.m_124288_((Block)SlabRegistry.NOTE_SLAB.get());
                this.m_124165_((Block)SlabRegistry.TNT_SLAB.get(), LootTable.m_79147_().m_79161_((LootPool.Builder)Blocks.m_124134_((ItemLike)((ItemLike)SlabRegistry.TNT_SLAB.get()), (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)SlabRegistry.TNT_SLAB.get())).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)SlabRegistry.TNT_SLAB.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)TNTSlabBlock.UNSTABLE, false)))))));
            }

            protected Iterable<Block> getKnownBlocks() {
                return SlabRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }
        }
    }

    private static class MineableProvider
    extends BlockTagsProvider {
        public MineableProvider(DataGenerator gen, ExistingFileHelper fileHelper) {
            super(gen, "slabmachines", fileHelper);
        }

        protected void m_6577_() {
            this.m_206424_(BlockTags.f_144280_).m_126582_((Object)((Block)SlabRegistry.CRAFTING_TABLE_SLAB.get())).m_126582_((Object)((Block)SlabRegistry.CHEST_SLAB.get())).m_126582_((Object)((Block)SlabRegistry.TRAPPED_CHEST_SLAB.get())).m_126582_((Object)((Block)SlabRegistry.NOTE_SLAB.get()));
            this.m_206424_(BlockTags.f_144282_).m_126582_((Object)((Block)SlabRegistry.FURNACE_SLAB.get()));
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "slabmachines", helper);
        }

        protected void registerModels() {
            this.makeSlab((Block)SlabRegistry.CRAFTING_TABLE_SLAB.get());
            this.makeSlab((Block)SlabRegistry.FURNACE_SLAB.get());
            this.makeSlab((Block)SlabRegistry.CHEST_SLAB.get());
            this.makeSlab((Block)SlabRegistry.TRAPPED_CHEST_SLAB.get());
            this.makeSlab((Block)SlabRegistry.NOTE_SLAB.get());
            this.makeSlab((Block)SlabRegistry.TNT_SLAB.get());
        }

        private void makeSlab(Block block) {
            String path = block.getRegistryName().m_135815_();
            ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + path)));
        }

        public String m_6055_() {
            return "Item Models";
        }
    }
}

